/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStepUtils;
import java.awt.Point;

public class VWStepFactory {
    public static VWMapNode createComponentStep(VWMapDefinition mapDef, String name, Point ptLoc) throws VWException {
        try {
            VWCompoundStepDefinition stepDef = mapDef.createCompoundStep(name);
            VWStepFactory.setDefaultStepValues(stepDef, ptLoc);
            VWStepUtils.setStepType(stepDef, 8);
            return stepDef;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static VWMapNode createGeneralStep(VWMapDefinition mapDef, String stepName, Point ptLoc) throws VWException {
        try {
            VWStepDefinition mapNode = mapDef.createStep(stepName);
            VWStepFactory.setDefaultStepValues(mapNode, ptLoc);
            VWStepUtils.setStepType(mapNode, 2);
            return mapNode;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static VWMapNode createSubmapStep(VWMapDefinition mapDef, String name, Point ptLoc) throws VWException {
        try {
            VWCompoundStepDefinition stepDef = mapDef.createCompoundStep(name);
            VWStepFactory.setDefaultStepValues(stepDef, ptLoc);
            VWStepUtils.setStepType(stepDef, 4);
            VWStepFactory.createFunction(5, stepDef);
            return stepDef;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static VWMapNode createSystemStep(VWMapDefinition mapDef, String name, Point ptLoc, int nActionType) throws VWException {
        try {
            VWCompoundStepDefinition stepDef = mapDef.createCompoundStep(name);
            VWStepFactory.setDefaultStepValues(stepDef, ptLoc);
            VWStepUtils.setStepType(stepDef, 6);
            VWStepFactory.createFunction(nActionType, stepDef);
            return stepDef;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public static void setDefaultStepValues(VWMapNode mapNode, Point ptLoc) throws VWException {
        mapNode.setLocation(ptLoc);
        mapNode.setJoinType(2);
        mapNode.setSplitType(2);
    }

    private static void createFunction(int nActionType, VWCompoundStepDefinition stepDef) {
        try {
            switch (nActionType) {
                case 0: {
                    stepDef.createAssignInstruction(null);
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/assign_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWAssignPropertiesPanel");
                    break;
                }
                case 27: {
                    stepDef.createBeginCheckPointInstruction();
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/begin_chkpoint_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWBeginChkpointPropertiesPanel");
                    break;
                }
                case 1: {
                    stepDef.createBeginTimerInstruction("", "", "", null);
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/begin_timer_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWBeginTimerPropertiesPanel");
                    break;
                }
                case 5: {
                    stepDef.createCallInstruction(null);
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/callstep", "filenet.vw.toolkit.design.property.steps.VWSubmapStepPropertyTabs");
                    break;
                }
                case 6: {
                    stepDef.createCreateInstruction("", null);
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/create_wflo_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWCreateWfloPropertiesPanel");
                    break;
                }
                case 37: {
                    stepDef.createDatabaseExecuteInstruction("", "", new String[0]);
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/db_execute_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWDBExecutePropertiesPanel");
                    break;
                }
                case 7: {
                    stepDef.createDelayInstruction("");
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/delay_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWDelayPropertiesPanel");
                    break;
                }
                case 8: {
                    stepDef.createEndAllTimersInstruction();
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/end_all_timers_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWEndAllTimersPropertiesPanel");
                    break;
                }
                case 28: {
                    stepDef.createEndCheckPointInstruction();
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/end_chkpoint_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWEndChkpointPropertiesPanel");
                    break;
                }
                case 9: {
                    stepDef.createEndTimerInstruction("");
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/end_timer_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWEndTimerPropertiesPanel");
                    break;
                }
                case 39: {
                    stepDef.createInvokeInstruction("", "");
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/invoke_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWInvokePropertiesPanel");
                    break;
                }
                case 38: {
                    stepDef.createLogInstruction("", "");
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/log_event_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWLogEventPropertiesPanel");
                    break;
                }
                case 40: {
                    VWInstructionDefinition instructionDef = stepDef.createReceiveInstruction("", "");
                    VWReceiveInstruction receiveInstruction = (VWReceiveInstruction)instructionDef;
                    receiveInstruction.setAuthentication(false);
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/receive_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWReceivePropertiesPanel");
                    break;
                }
                case 41: {
                    VWInstructionDefinition instructionDef = stepDef.createReplyInstruction("", "");
                    VWReplyInstruction replyInstruction = (VWReplyInstruction)instructionDef;
                    replyInstruction.setHasAttachments(true);
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/reply_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWReplyPropertiesPanel");
                    break;
                }
                case 13: {
                    stepDef.createResumeTimerInstruction("");
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/resume_timer_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWResumeTimerPropertiesPanel");
                    break;
                }
                case 14: {
                    stepDef.createReturnInstruction("");
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/return_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWReturnPropertiesPanel");
                    break;
                }
                case 29: {
                    stepDef.createRollbackCheckpointInstruction("", null, null);
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/rollback_chkpoint_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWRollbackChkpointPropertiesPanel");
                    break;
                }
                case 16: {
                    stepDef.createSuspendTimerInstruction("");
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/suspend_timer_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWSuspendTimerPropertiesPanel");
                    break;
                }
                case 17: {
                    stepDef.createTerminateBranchInstruction();
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/terminate_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWTerminateProcessPropertiesPanel");
                    break;
                }
                case 42: {
                    stepDef.createTerminateProcessInstruction();
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/terminate_process_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWTerminateProcessPropertiesPanel");
                    break;
                }
                case 19: {
                    stepDef.createWFEInstruction("0", "");
                    VWStepFactory.addAttributes(stepDef, "filenet/vw/toolkit/utils/images/wait_for_condition_step", "filenet.vw.toolkit.design.property.steps.systeminstructions.VWWaitForConditionPropertiesPanel");
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private static void addAttributes(VWMapNode mapNode, String stepIconName, String panelName) {
        try {
            VWAttributeInfo attributeInfo = mapNode.getAttributeInfo();
            if (attributeInfo == null) {
                attributeInfo = new VWAttributeInfo();
            }
            attributeInfo.setFieldValue("UI_IconName", stepIconName);
            attributeInfo.setFieldValue("UI_StepPropertiesPanelClass", panelName);
            mapNode.setAttributeInfo(attributeInfo);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

